
#include "networksocket.h"

/////////////////////////////////////////////////////////////////////////////////////////
///////////////////               Server Functions                   ////////////////////
/////////////////////////////////////////////////////////////////////////////////////////



void NetworkServer::Init(int pt)
{
  port = pt;
  int yes = 1;
  //Clear the hints struct
  memset(&hints, 0, sizeof hints);
  
  //Set up hints struct
  hints.ai_family = AF_UNSPEC; //ipv4 or ipv6, doesn't matter
  hints.ai_socktype = SOCK_STREAM; //use socket streams
  hints.ai_flags = AI_PASSIVE; //use my ip

  char p[10];
  sprintf(p, "%d", port);
  getaddrinfo(NULL, p, &hints, &result);

  servfd = socket(result->ai_family,result->ai_socktype,result->ai_protocol);
  setsockopt(servfd, SOL_SOCKET, SO_REUSEADDR, &yes, sizeof(int));

  bind(servfd, result->ai_addr, result->ai_addrlen);

  freeaddrinfo(result);
  listen(servfd, 10);
}

void NetworkServer::Accept()
{
  cout << "Waiting for connections..." << endl;
  socklen_t addrsize = sizeof their_addr;
  clientfd = accept(servfd, (struct sockaddr*)&their_addr, &addrsize);
}

int NetworkServer::Send(char *data, int size)
{
  return send(clientfd, data, size, 0);
}

int NetworkServer::Receive(char *data, int size)
{
  return recv(clientfd, data, size, 0);
}
/////////////////////////////////////////////////////////////////////////////////////////
///////////////////               Client Functions                   ////////////////////
/////////////////////////////////////////////////////////////////////////////////////////

void NetworkClient::Init(int p, string hostname)
{
  port = p;
  
  memset(&hints, 0, sizeof hints);
  
  hints.ai_family = AF_UNSPEC;
  hints.ai_socktype = SOCK_STREAM;
  
  char portchar[10];
  sprintf(portchar, "%d", port); //Convert port int value to char array

  getaddrinfo(hostname.c_str(), portchar, &hints, &result);

  servfd = socket(result->ai_family, result->ai_socktype, result->ai_protocol);
  cout << "fd: " << servfd << endl;
}

void NetworkClient::Connect()
{
  connect(servfd, result->ai_addr, result->ai_addrlen);
}

int NetworkClient::Send(char *data, int size)
{
  return send(servfd, data, size, 0);
}

int NetworkClient::Receive(char *data, int size)
{
  return recv(servfd, data, size, 0);
}
